#define Attente_STX       0
#define Attente_Fonction  1
#define Attente_Parametre 2
#define Attente_EOT       4
#define Traiter_Trame     5

#define PilotageLed '1'

#define STX '2'
#define EOT '4'

#define led 13

void setup() {
  Serial.begin(9600);
  pinMode(led,OUTPUT);
  digitalWrite(led, LOW);
}

void loop() {

//c1//  unsigned long temps=0;
  byte b, parametre, fonction;
  byte action_suivante = Attente_STX;

  do {

//c1//    //en cas de trame incomplète en 50ms, on repasse en mode "attente du STX"
//c1//    if ((temps != 0) and ( millis()-temps > 50 ))
//c1//        action_suivante = Attente_STX;


    if (Serial.available()) {
      b = Serial.read();
      switch (action_suivante) {
        case Attente_STX:
          if (b == STX) {
            action_suivante = Attente_Fonction;  // On a recu STX, on attend maintenant la fonction
//c1//            temps = millis();
          }
        break;
  
        case Attente_Fonction:
          if (b == PilotageLed)  {
            fonction = b;
            action_suivante = Attente_Parametre;
          }
          else action_suivante = Attente_STX;
        break;
        
        case Attente_Parametre:
          if ( (b=='0') or (b=='1') ) {
            parametre = b;
            action_suivante = Attente_EOT;
          }
          else action_suivante = Attente_STX;
        break;

        case Attente_EOT:
          if (b == EOT) {
            // On a recu EOT, la trame est valide, on traite la fonction
            if (fonction==PilotageLed) {
              if (parametre=='0')
                digitalWrite(led, LOW);
              else if (parametre=='1')
                digitalWrite(led, HIGH);
            }
          }
          action_suivante = Attente_STX;
//c1//          temps=0;
        break;
        
      }
    }

  } while (true);
}

